using System;
using System.Collections.Generic;
using System.Text;
using System.IO.Ports;
using System.Collections;
using Microsoft.Win32;
using System.IO;

namespace FS28BluetoothMasterModeDemo
{
    public class FamSerialComm
    {
        private static Hashtable m_htFriendlyNameComPorts;
        private string m_strComPort;

        public static void EnumerateComPorts()
        {
            m_htFriendlyNameComPorts = BuildPortNameHash(SerialPort.GetPortNames());
        }

        public static Hashtable FriendlyNameComPorts
        {
            get { return m_htFriendlyNameComPorts; }
        }
        /// <summary>
        /// Begins recursive registry enumeration
        /// </summary>
        /// <param name="oPortsToMap">array of port names (i.e. COM1, COM2, etc)</param>
        /// <returns>a hashtable mapping Friendly names to non-friendly port values</returns>
        private static Hashtable BuildPortNameHash(string[] oPortsToMap)
        {
            Hashtable oReturnTable = new Hashtable();
            MineRegistryForPortName("SYSTEM\\CurrentControlSet\\Enum", oReturnTable, oPortsToMap);
            return oReturnTable;
        }
        /// <summary>
        /// Recursively enumerates registry subkeys starting with strStartKey looking for 
        /// "Device Parameters" subkey. If key is present, friendly port name is extracted./// </summary>
        /// <param name="strStartKey">the start key from which to begin the enumeration</param>
        /// <param name="oTargetMap">hashtable that will get populated with 
        /// friendly-to-nonfriendly port names</param>
        /// <param name="oPortNamesToMatch">array of port names (i.e. COM1, COM2, etc)</param>
        private static void MineRegistryForPortName(string strStartKey, Hashtable oTargetMap, string[] oPortNamesToMatch)
        {
            if (oTargetMap.Count >= oPortNamesToMatch.Length)
                return;
            RegistryKey oCurrentKey = Registry.LocalMachine;
            try
            {
                oCurrentKey = oCurrentKey.OpenSubKey(strStartKey);
            }
            catch (Exception)
            {
                return;
            }
            string[] oSubKeyNames = oCurrentKey.GetSubKeyNames();
            bool bContain = false;
            foreach (string oSubkeyName in oSubKeyNames)
            {
                if (oSubkeyName.Contains("Device Parameters"))
                {
                    bContain = true;
                    break;
                }
            }
            if (bContain && strStartKey != "SYSTEM\\CurrentControlSet\\Enum")
            {
                object oPortNameValue = Registry.GetValue("HKEY_LOCAL_MACHINE\\" +
                    strStartKey + "\\Device Parameters", "PortName", null);
                if (oPortNameValue == null) //|| oPortNamesToMatch.Contains(oPortNameValue.ToString()) == false)
                    return;
                bContain = false;
                foreach (string oPortName in oPortNamesToMatch)
                {
                    if (oPortNameValue.ToString().Length > 0 && oPortName.Contains(oPortNameValue.ToString()))
                    {
                        bContain = true;
                        break;
                    }
                }
                if (!bContain)
                    return;

                object oFriendlyName = Registry.GetValue("HKEY_LOCAL_MACHINE\\" +
                    strStartKey, "FriendlyName", null);
                string strFriendlyName = "N/A";
                if (oFriendlyName != null)
                    strFriendlyName = oFriendlyName.ToString();
                if (strFriendlyName.Contains(oPortNameValue.ToString()) == false)
                    strFriendlyName = string.Format("{0} ({1})", strFriendlyName, oPortNameValue);
                oTargetMap[oPortNameValue] = strFriendlyName;
            }
            else
            {
                foreach (string strSubKey in oSubKeyNames)
                    MineRegistryForPortName(strStartKey + "\\" + strSubKey, oTargetMap, oPortNamesToMatch);
            }
        }

        public string ComPort
        {
            get { return m_strComPort; }
            set { m_strComPort = value; }
        }
    }
}
